# netscaler_web_detect.nasl
# GPLv2
#
# History:
#
# 1.00, 11/21/07
# - Initial release
# kst-depend-rpc


if (description)
    {
    script_id(80024);
    script_version("$Revision: 1.1 $");
    script_tag(name:"risk_factor", value:"None");
    name="NetScaler web management interface detection";
    desc="
Synopsis :

A Citrix NetScaler web management interface is running on this port. 

Description :

The remote host appears to be a Citrix NetScaler, an appliance for web
application delivery, and the remote web server is its management
interface. 

See also :

http://www.citrix.com/lang/English/ps2/index.asp

Solution :

Filter incoming traffic to this port. 

Risk factor : 

None";
    summary="Detects NetScaler web management interface";
    family="Web Servers";
    script_name(name);
    script_description(desc);
    script_summary(summary);
    script_family(family);
    script_category(ACT_GATHER_INFO);
    script_copyright("This script is Copyright (c) 2007 nnposter");
    script_dependencies("find_service1.nasl","httpver.nasl");
    script_require_ports("Services/www",80);
    exit(0);
    }


include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


port=get_http_port(default:80);
if (!get_tcp_port_state(port)) exit(0);

resp=http_keepalive_send_recv(port:port,
                              data:http_get(item:"/index.html",port:port),
                              embedded:TRUE);
if (!resp) exit(0);

match1=egrep(pattern:"<title>Citrix Login</title>",string:resp,icase:TRUE);
match2=egrep(pattern:'action="/ws/login\\.pl"',string:resp,icase:TRUE);
if (!match1 || !match2) exit(0);

replace_kb_item(name:"www/netscaler",value:TRUE);
replace_kb_item(name:"www/netscaler/"+port,value:TRUE);
replace_kb_item(name:"Services/www/"+port+"/embedded",value:TRUE);

security_note(port);
