###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for python2.4, python2.5 vulnerabilities USN-632-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840343);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "632-1");
  script_cve_id("CVE-2008-1679", "CVE-2008-1721", "CVE-2008-1887", "CVE-2008-2315", "CVE-2008-2316", "CVE-2008-3142", "CVE-2008-3143", "CVE-2008-3144");
  script_name( "Ubuntu Update for python2.4, python2.5 vulnerabilities USN-632-1");
  desc = "

  Vulnerability Insight:

  It was discovered that there were new integer overflows in the imageop
  module.  If an attacker were able to trick a Python application into
  processing a specially crafted image, they could execute arbitrary code
  with user privileges. (CVE-2008-1679)
  
  Justin Ferguson discovered that the zlib module did not correctly
  handle certain archives.  If an attacker were able to trick a Python
  application into processing a specially crafted archive file, they could
  execute arbitrary code with user privileges. (CVE-2008-1721)
  
  Justin Ferguson discovered that certain string manipulations in Python
  could be made to overflow.  If an attacker were able to pass a specially
  crafted string through the PyString_FromStringAndSize function, they
  could execute arbitrary code with user privileges. (CVE-2008-1887)
  
  Multiple integer overflows were discovered in Python's core and modules
  including hashlib, binascii, pickle, md5, stringobject, unicodeobject,
  bufferobject, longobject, tupleobject, stropmodule, gcmodule, and
  mmapmodule.  If an attacker were able to exploit these flaws they could
  execute arbitrary code with user privileges or cause Python applications
  to crash, leading to a denial of service. (CVE-2008-2315, CVE-2008-2316,
  CVE-2008-3142, CVE-2008-3143, CVE-2008-3144).

  Affected Software/OS:
  python2.4, python2.5 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-August/000736.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of python2.4, python2.5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-gdbm", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-tk", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.3-0ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.4-2ubuntu7.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.5-1ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.2-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.4-6ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.1-5ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}