###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_strongswan_mult_dos_vuln.nasl 2748 2009-06-17 15:05:27Z jun $
#
# strongSwan IKE_SA_INIT and IKE_AUTH DoS Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800632);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1957", "CVE-2009-1958");
  script_bugtraq_id(35178);
  script_name("strongSwan IKE_SA_INIT and IKE_AUTH DoS Vulnerabilities");
  desc = "

  Overview: This host has installed strongSwan and is prone to Denial of Service
  Vulnerabilities.

  Vulnerability Insight:
  The flaws are due to,
  - An error in charon/sa/ike_sa.c charon daemon which results in NULL pointer
    dereference and crash via an invalid 'IKE_SA_INIT' request that triggers
   'an incomplete state,' followed by a 'CREATE_CHILD_SA' request.
  - An error in incharon/sa/tasks/child_create.c charon daemon, it switches
    the NULL checks for TSi and TSr payloads, via an 'IKE_AUTH' request without
    a 'TSi' or 'TSr' traffic selector.

  Impact:
  Successful exploit allows attackers to run arbitrary code, corrupt memory,
  and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  strongSwan Version prior to 4.2.15 and 4.3.1

  Fix: Upgrade to version 4.3.1 or 4.2.15 or apply patches
  http://download.strongswan.org/patches/
  http://www.strongswan.org/download.htm

  *****
  NOTE: Ignore this warning, if above mentioned Update is applied already.
  *****

  References:
  http://www.vupen.com/english/advisories/2009/1476
  http://www.openwall.com/lists/oss-security/2009/06/06/9
  https://lists.strongswan.org/pipermail/users/2009-May/003457.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Checks for the Version of strongSwan");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_strongswan_detect.nasl");
  script_require_keys("StrongSwan/Ver");
  exit(0);
}


include("version_func.inc");

strongswanVer = get_kb_item("StrongSwan/Ver");

# Check version 4.1.0 to 4.3.0 and Except 4.2.15
if(strongswanVer != NULL && strongswanVer != "4.2.15")
{
  if(version_in_range(version:strongswanVer, test_version:"4.1.0",
                                             test_version2:"4.3.0")){
    security_warning(0);
  }
}
