###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ideal_administrator_bof_vuln.nasl 6181 2009-12-11 20:27:29Z dec $
#
# IDEAL Administration '.ipj' File Processing Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801089);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4265");
  script_name("IDEAL Administration '.ipj' File Processing Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is installed with IDEAL Administration and is prone to
  Buffer Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to a boundary error in the processing of Ideal Project
  Files ('.ipj'). This can be exploited to cause a stack based buffer overflow
  when a user is tricked into opening a specially crafted '.ipj' file through
  the application.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code or
  compromise a user's system.

  Impact level: System.

  Affected Software/OS:
  IDEAL Administration 9.7.1 and prior.

  Fix:
  No solution or patch is available as on 11th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further information refer, http://www.pointdev.com/en/download/index.php

  References:
  http://freetexthost.com/abydoz3jwu
  http://secunia.com/advisories/37572
  http://pocoftheday.blogspot.com/2009/12/ideal-administration-2009-v97-local.html

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.4
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of IDEAL Administration");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_ideal_administrator_detect.nasl");
  script_require_keys("IDEAL/Admin/Ver");
  exit(0);
}


include("version_func.inc");

# Check for IDEAL Administration 2009 (v9.7.1) and prior
if(iaVer = get_kb_item("IDEAL/Admin/Ver"))
{
  if(version_is_less_equal(version:iaVer, test_version:"9.7.1")){
    security_hole(0);
  }
}
