###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_db2_bof_vuln_lin_feb10.nasl 7041 2010-02-01 20:11:27Z feb $
#
# IBM DB2 'REPEAT()' Heap Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800448);
  script_version("$Revision$:1.0");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2010-0462");
  script_bugtraq_id(37976);
  script_name("IBM DB2 'REPEAT()' Heap Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with IBM DB2 and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'REPEAT()' function when processing SELECT statement
  that has a long column name generated.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code with
  elevated privileges or crash the affected application.

  Impact Level: System/Application

  Affected Software/OS:
  IBM DB2 version 9.7.1 and prior.

  Fix:
  No solution or patch is available as on 01st February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www-01.ibm.com/software/data/db2/express/download.html

  References:
  httphttp://xforce.iss.net/xforce/xfdb/55899
  http://securitytracker.com/alerts/2010/Jan/1023509.html
  http://intevydis.blogspot.com/2010/01/ibm-db2-97-heap-overflow.html

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.7
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of IBM DB2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Databases");
  script_dependencies("secpod_ibm_db2_detect_linux_900217.nasl");
  script_require_keys("Linux/IBM_db2/Ver");
  exit(0);
}


include("version_func.inc");

ibmVer = get_kb_item("Linux/IBM_db2/Ver");
if(!ibmVer){
  exit(0);
}

# Check for IBM DB2 Version 9.7.1(9.7.0.1)and prior.
if(version_in_range(version:ibmVer, test_version:"9.7", test_version2:"9.7.0.1")){
  security_hole(0);
}
