###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for CDE HPSBUX00151
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835112);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00151");
  script_name( "HP-UX Update for CDE HPSBUX00151");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  CDE. The vulnerability could be exploitedlocally to gain increased privilege 
  or create a denial of service (DoS). 

  Impact:
  Local increased privilege
  denial of service (DoS)

  Affected Software/OS:
  CDE on
  HP-UX B.10.10, B.10.20, B.10.24, B.11.00, B.11.04 and B.11.11 running CDE. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00994219-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of CDE");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX10.10")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_23355'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_23355'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_23355'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-HELP-RUN", patch_list:['PHSS_23355'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT", patch_list:['PHSS_23355'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE-TT", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-HELP-RUN", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-DTTERM", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MAN", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-HELP", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-FONTS", patch_list:['PHSS_23797'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_24097'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN CDE.CDE-RUN", patch_list:['PHSS_24097'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-HELP-RUN", patch_list:['PHSS_24097'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-PAM CDE.CDE-SHLIBS", patch_list:['PHSS_24097'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT CDE.CDE-DTTERM", patch_list:['PHSS_24097'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-HELP-RUN", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-DTTERM", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MAN", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-HELP", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-FONTS", patch_list:['PHSS_24098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-HELP-RUN", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-PAM", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-DTTERM", patch_list:['PHSS_23796'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_24087 PHSS_24091'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_24087 PHSS_24091'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
