###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kdebase FEDORA-2007-716
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861017);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-716");
  script_cve_id("CVE-2007-4224", "CVE-2007-4225", "CVE-2007-3820", "CVE-2007-4569");
  script_name( "Fedora Update for kdebase FEDORA-2007-716");
  desc = "

  Vulnerability Insight:
  Core applications for the K Desktop Environment.  Included are: kdm
  (replacement for xdm), kwin (window manager), konqueror (filemanager,
  web browser, ftp client, ...), konsole (xterm replacement), kpanel
  (application starter and desktop pager), kaudio (audio server),
  kdehelp (viewer for kde help files, info and man pages), kthememgr
  (system for managing alternate theme packages) plus other KDE
  components (kcheckpass, kikbd, kscreensaver, kcontrol, kfind,
  kfontmanager, kmenuedit)


  Affected Software/OS:
  kdebase on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00084.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdebase");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"kdebase", rpm:"kdebase~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/kdebase-debuginfo", rpm:"x86_64/debug/kdebase-debuginfo~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdebase-devel", rpm:"x86_64/kdebase-devel~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdebase", rpm:"x86_64/kdebase~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdebase", rpm:"i386/kdebase~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/kdebase-debuginfo", rpm:"i386/debug/kdebase-debuginfo~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdebase-devel", rpm:"i386/kdebase-devel~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}