###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_e107_easyshop_remote_sql_inj_vuln.nasl 415 2008-11-07 15:44:11Z nov $
#
# e107 EasyShop plugin easyshop.php SQL Injection Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800302);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-4786");
  script_name("e107 EasyShop plugin easyshop.php SQL Injection Vulnerability");
  desc = "

  Overview: This host is running e107 and is prone to SQL injection vulnerability.

  Vulnerability Insight:
  The flaw exists due to easyshop.php file in the EasyShop plugin, which can be
  exploited to conduct SQL injection by using execute commands via the
  category_id parameter.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  SQL commands.

  Impact Level: Application

  Affected Software/OS:
  e107 version 0.7.13, EasyShop Plugin.

  Fix: Upgrade to e107 version 0.7.22 or later,
  For updates refer, http://e107.org/edownload.php

  References:
  http://www.milw0rm.com/exploits/6852
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-4786

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of e107");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach path (make_list("/e107/e107_plugins/easyshop", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/easyshop.php?allcat"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"e107 Powered Website: EasyShop", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    security_warning(port);
    exit(0);
  }
}
