#
#VID 249a8c42-6973-11d9-ae49-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52227);
 script_cve_id("CVE-2004-0994");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: zgv";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   zgv
   xzgv

CVE-2004-0994
Multiple integer overflows in xzgv 0.8 and earlier allow remote
attackers to execute arbitrary code via images with large width and
height values, which trigger a heap-based buffer overflow, as
demonstrated in the read_prf_file function in readprf.c.  NOTE:
CVE-2004-0994 and CVE-2004-1095 identify sets of bugs that only
partially overlap, despite having the same developer.  Therefore, they
should be regarded as distinct.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://rus.members.beeb.net/xzgv.html
http://www.svgalib.org/rus/zgv/
http://www.idefense.com/application/poi/display?id=160&type=vulnerabilities&flashstatus=false
http://marc.theaimsgroup.com/?l=bugtraq&m=109886210702781
http://marc.theaimsgroup.com/?l=bugtraq&m=109898111915661
http://www.vuxml.org/freebsd/249a8c42-6973-11d9-ae49-000c41e2cdad.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: zgv";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"zgv");
if(!isnull(bver) && revcomp(a:bver, b:"5.8_1")<0) {
    security_note(0, data:"Package zgv version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xzgv");
if(!isnull(bver) && revcomp(a:bver, b:"0.8_2")<0) {
    security_note(0, data:"Package xzgv version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
