#
#VID 338d1723-5f03-11d9-92a7-000bdb1444a4
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52213);
 script_bugtraq_id(12255);
 script_cve_id("CVE-2005-0378");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: horde, horde-php5";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   horde
   horde-php5

CVE-2005-0378:
Multiple cross-site scripting (XSS) vulnerabilities in Horde 3.0
allow remote attackers to inject arbitrary web script or HTML via
the (1) group parameter to prefs.php or (2) url parameter to index.php.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=110564059322774
http://lists.horde.org/archives/announce/2005/000159.html
http://www.vuxml.org/freebsd/338d1723-5f03-11d9-92a7-000bdb1444a4.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: horde, horde-php5";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"horde");
if(!isnull(bver) && revcomp(a:bver, b:"3")>0 && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package horde version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"horde-php5");
if(!isnull(bver) && revcomp(a:bver, b:"3")>0 && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package horde-php5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
