# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9044 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64736);
 script_cve_id("CVE-2009-2691", "CVE-2009-2848", "CVE-2009-2849", "CVE-2009-2847", "CVE-2009-2695", "CVE-2009-2767", "CVE-2009-2692", "CVE-2009-1897", "CVE-2009-1895", "CVE-2009-2406", "CVE-2009-2407");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-9044 (kernel)");

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-9044.

Update Information:

Security fixes:

- CVE-2009-2691: Information disclosure in proc filesystem
- CVE-2009-2848: execve: must clear current->child_tid
- CVE-2009-2849: md: null pointer dereference
- CVE-2009-2847: Information leak in do_sigaltstack

Restore missing LIRC drivers, dropped in previous release.
Backport upstream fixes that further improve the security of
mmap of low addresses.  (CVE-2009-2695)

ChangeLog:

* Thu Sep 24(??!!) 2009 Chuck Ebbert  2.6.29.6-217.2.16
- Fix CVE-2009-2691: local information disclosure in /proc
* Fri Aug 21 2009 David Woodhouse 
- Fix b43 on iMac G5 (#514787)
* Tue Aug 18 2009 Kyle McMartin 
- CVE-2009-2848: execve: must clear current->clear_child_tid
- Cherry pick upstream commits 52dec22e739eec8f3a0154f768a599f5489048bd
which improve mmap_min_addr.
- CVE-2009-2849: md: avoid dereferencing null ptr when accessing suspend
sysfs attributes.
- CVE-2009-2847: do_sigaltstack: avoid copying 'stack_t' as a structure
to userspace

References:

[ 1 ] Bug #516171 - CVE-2009-2691 kernel: /proc/$pid/maps visible during initial setuid ELF loading
https://bugzilla.redhat.com/show_bug.cgi?id=516171
[ 2 ] Bug #515423 - CVE-2009-2848 kernel: execve: must clear current->clear_child_tid
https://bugzilla.redhat.com/show_bug.cgi?id=515423
[ 3 ] Bug #518132 - CVE-2009-2849 kernel: md: NULL pointer deref when accessing suspend_* sysfs attributes
https://bugzilla.redhat.com/show_bug.cgi?id=518132
[ 4 ] Bug #515392 - CVE-2009-2847 kernel: information leak in sigaltstack
https://bugzilla.redhat.com/show_bug.cgi?id=515392
[ 5 ] Bug #517830 - CVE-2009-2695 SELinux and mmap_min_addr
https://bugzilla.redhat.com/show_bug.cgi?id=517830

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9044

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9044 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.29.6~217.2.16.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
