# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 890-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55845);
 script_cve_id("CVE-2005-2974", "CVE-2005-3350");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 890-1 (libungif4)";
 script_name(name);

 desc = "The remote host is missing an update to libungif4
announced via advisory DSA 890-1.

Chris Evans discovered several security related problems in libungif4,
a shared library for GIF images.  The Common Vulnerabilities and
Exposures project identifies the following vulnerabilities:

CVE-2005-2974

Null pointer dereference, that could cause a denial of service.

CVE-2005-3350

Out of bounds memory access that could cause a denial of service
or the execution of arbitrary code.

For the old stable distribution (woody) these problems have been fixed in
version 4.1.0b1-2woody1.

For the stable distribution (sarge) these problems have been fixed in
version 4.1.3-2sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your libungif4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20890-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 890-1 (libungif4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libungif-bin", ver:"4.1.0b1-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libungif4-dev", ver:"4.1.0b1-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libungif4g", ver:"4.1.0b1-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libungif-bin", ver:"4.1.3-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libungif4-dev", ver:"4.1.3-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libungif4g", ver:"4.1.3-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
