#
#
# Copyright 2005 DN Systems GmbH
#
# License: GNU GPLv2 or any later version
#

debug = 0;

include ("ssh_func.inc");
include ("slad_ssh.inc");
include ("slad.inc");

if (description) {
  script_id(90002);
  script_version ("1.0");
  name["english"] = "SLAD Run";
  
  script_name(english:name["english"]);
  
  desc["english"] = "
This script connects to SLAD on a remote host to run
remote scanners.
To work properly, this script requires to be provided
with a valid SSH login by means of an SSH key with pass-
phrase if the SSH public key is passphrase-protected, or
a password to log in.";

  script_description(english:desc["english"]);
  
  summary["english"] = "Connects to SLAD to tun programs remotely";
  script_summary(english:summary["english"]);
  
  script_category(ACT_GATHER_INFO);
  
  script_copyright(english:"This script is Copyright 2005 DN Systems GmbH");
  family["english"] = "SLAD";
  script_family(english:family["english"]);
  
  script_dependencies ("find_service.nes", "slad_init.nasl");
  script_require_ports (22, "Services/ssh");

  # Dynamic entries for running from slad.inc
  init_add_preferences ();

  exit(0);
}

{
  if (debug)
    dump_preferences ();

  sock = slad_ssh_login ();
  run_slad (sock: sock, slad_exe: "/opt/slad/bin/sladd");
  
  close (sock);
}
