#
#
# Copyright 2005 DN Systems GmbH
#
# License: GNU GPLv2 or any later version
#

debug = 0;
slad_login_name = "slad";

if(description) {
  script_id(90001);
  script_version ("1.0");
  name["english"] = "SLAD Init";
  
  script_name(english:name["english"]);
  
  desc["english"] = "
This script provides the SLAD scripts with login
information.";

  script_description(english:desc["english"]);
  
  summary["english"] = "Set SLAD login information";
  script_summary(english:summary["english"]);
  
  script_category(ACT_INIT);
  
  script_copyright(english:"This script is Copyright 2005 DN Systems GmbH");
  family["english"] = "SLAD";
  script_family(english:family["english"]);
  
  # The script preferences
  script_add_preference (name: "slad SSH public key:", type: "file",
			 value: "");
  script_add_preference (name: "slad SSH private key:", type: "file",
			 value: "");
  script_add_preference (name: "slad SSH key passphrase:", type: "password",
			 value: "");
  exit(0);
}

{
  if (debug) {
    display ("kb: n: <", get_kb_item ("SLAD/login"), ">\n");
    display ("pub: ", get_kb_item ("SLAD/publickey"), "\n");
    display ("priv: ", get_kb_item ("SLAD/privatekey"), "\n");
  }

  # Get the values from the script preferences
  slad_public_key = script_get_preference_file_content ("slad SSH public key:");
  slad_private_key = script_get_preference_file_content ("slad SSH private key:");
  slad_key_passphrase = script_get_preference ("slad SSH key passphrase:");

  if (debug) {
    display ("d1: pp: <", slad_key_passphrase, ">\n");
    display ("pub: ", slad_public_key, "\n");
    display ("priv: ", slad_private_key, "\n");
  }

  # Store secret information for running/fetching results
  if (slad_key_passphrase)
    replace_kb_item (name: "Secret/SLAD/passphrase", value: slad_key_passphrase);

  replace_kb_item (name: "SLAD/login", value: slad_login_name);

  if (slad_public_key)
    replace_kb_item (name: "SLAD/publickey", value: slad_public_key);

  if (slad_private_key)
    replace_kb_item (name: "SLAD/privatekey", value: slad_private_key);
}
