###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ziproxy_sec_bypass_vuln.nasl 754 2009-03-25 16:35:29Z mar $
#
# Ziproxy Security Bypass Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900523);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0804");
  script_bugtraq_id(33858);
  script_name(english:"Ziproxy Security Bypass Vulnerability");
  desc["english"] = "

  Overview: This host is running Ziproxy server and is prone to security
  bypass vulnerability.

  Vulnerability Insight:
  This vulnerability arises because ziproxy depends on HTTP Host headers
  to determine the remote endpoints while acting as a transparent proxy.

  Impact:
  This can be exploited to restrict websites or bypass a browser's
  security context protection mechanism by sending HTTP requests with
  forged HTTP Host header.

  Impact Level: System/Application

  Affected Software/OS:
  Ziproxy version 2.6.0 and prior on Linux.

  Fix: No solution or patch is available as on 26th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://ziproxy.sourceforge.net/

  References:
  http://secunia.com/advisories/34018/
  http://www.kb.cert.org/vuls/id/435052

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:C/I:N/A:N)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Ziproxy");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Privilege escalation");
  script_dependencies("secpod_ziproxy_server_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("version_func.inc");

zipPort = get_kb_item("Services/www");
if(!zipPort){
  exit(0);
}

ziproxyVer = get_kb_item("www/" + zipPort + "/Ziproxy");
if(!ziproxyVer){
  exit(0);
}

if(version_is_less_equal(version:ziproxyVer, test_version:"2.6.0")){
  security_hole(zipPort);
}
