###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tcpdb_sec_bypass_vuln.nasl 2380 2009-05-25 11:06:33Z may $
#
# TCPDB Security Bypass Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900551);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1670");
  script_bugtraq_id(34866);
  script_name(english:"TCPDB Security Bypass Vulnerability");
  desc["english"] = "

  Overview: This host is installed with TCPDB and is prone to security bypass
  vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to the application not properly restricting
  access to certain administrative pages. (e.g. 'user/index.php')

  Impact:
  Successful exploitation will allow remote attackers to bypass security
  restrictions and add admin accounts, via unspecified vectors in
  user/index.php script.

  Impact Level: Application

  Affected Software/OS:
  TCPDB version 3.8 and prior.

  Fix: No solution or patch is available as on 28th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,http://www.tcpdb.com/index.php

  References:
  http://secunia.com/advisories/34966
  http://xforce.iss.net/xforce/xfdb/50371

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of TCPDB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("secpod_tcpdb_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tPort = get_http_port(default:80);
if(!tPort){
  exit(0);
}

tcpdbVer = get_kb_item("www/" + tPort + "/TCPDB");
tcpdbVer = eregmatch(pattern:"^(.+) under (/.*)$", string:tcpdbVer);

if(tcpdbVer[1] != NULL)
{
  if(version_is_less_equal(version:tcpdbVer[1], test_version:"3.8")){
     security_hole(tPort);
   }
}
