###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_seamonkey_mult_vuln_apr09_lin.nasl 1903 2009-04-24 15:43:57Z apr $
#
# Mozilla Seamonkey Multiple Vulnerabilities Apr-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900347);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305",
                "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309",
                "CVE-2009-1311", "CVE-2009-1312");
  script_bugtraq_id(34656);
  script_name(english:"Mozilla Seamonkey Multiple Vulnerabilities Apr-09 (Linux)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Seamonkey and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  For more information about vulnerabilities on Seamonkey, go through the links
  mentioned in references.

  Impact:
  Successful exploitation could result in Information Disclosure, XSS, Script
  Injection, Memory Corruption, CSRF, Arbitrary JavaScript code execution or
  can cause denial of service attacks.

  Impact Level: System/Application

  Affected Software/OS:
  Seamonkey version prior to 1.1.17 on Linux.

  Fix: Upgrade to Seamonkey version 1.1.17
  http://www.seamonkey-project.org/releases

  References:
  http://secunia.com/advisories/34835
  http://www.mozilla.org/security/announce/2009/mfsa2009-14.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-16.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-17.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-18.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-19.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-21.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-22.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("gb_seamonkey_detect_lin.nasl");
  script_require_keys("Seamonkey/Linux/Ver");
  exit(0);
}


include("version_func.inc");

smVer = get_kb_item("Seamonkey/Linux/Ver");
if(!smVer){
  exit(0);
}

# Grep for Seamonkey version prior to 1.1.17
if(version_is_less(version:smVer, test_version:"1.1.17")){
  security_hole(0);
}
