###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_live_msngr_charset_dos_vuln.nasl 1044 2009-02-20 15:40:29Z feb $
#
# Microsoft MSN Live Messneger Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900461);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(33825);
  script_cve_id("CVE-2009-0647");
  script_name(english:"Microsoft MSN Live Messneger Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host is running Microsoft MSN Live Messenger and is prone
  to Denial of Service Vulnerability.

  Vulnerability Insight:
  This flaw is due to failure in handling charset of the message which user
  sends.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and can cause denial of service.

  Impact level: Application/System

  Affected Software/OS:
  Microsoft Live Messenger version 14.0.8064.206 and prior.

  Fix: Solution/patch not available as on 20th February 2009. For updates
  refer, http://www.messenger.live.com

  References:
  http://www.securityfocus.com/archive/1/501043

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium ";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Live Messenger");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("gb_ms_win_live_messenger_detect.nasl");
  script_require_keys("MS/LiveMessenger/Ver");
  exit(0);
}


include("version_func.inc");

liveVer = get_kb_item("MS/LiveMessenger/Ver");
if(!liveVer){
  exit(0);
}

# Grep for 'msnmsgr.exe' version 14.0.8064.0206 or prior.
if(version_is_less_equal(version:liveVer, test_version:"14.0.8064.0206")){
  security_warning(0);
}

