###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-006.nasl 0868 2009-03-11 08:23:254Z mar $
#
# Vulnerabilities in Windows Kernel Could Allow Remote Code Execution (958690)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900086);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0081", "CVE-2009-0082", "CVE-2009-0083");
  script_bugtraq_id(34012, 34025, 34027);
  script_name(english:"Vulnerabilities in Windows Kernel Could Allow Remote Code Execution (958690)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-006.

  Vulnerability Insight:
  - Input validation error when passing input from user-mode through the
    kernel component of GDI. e.g. tricking a user into viewing a specially
    crafted Enhanced MetaFile (EMF) or Windows MetaFile (WMF) image file
    hosted on a malicious website.
  - Error in the kernel when validating handles and while handling certain
    invalid pointers.

  Impact:
  Successful exploitation may lead users to run arbitrary code with escalated
  privileges.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-006.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-006.mspx

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 6.7
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 958690 (MS09-006)
if(hotfix_missing(name:"958690") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Win32k.sys");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Win32k.sys version < 5.0.2195.7251
  if(version_is_less(version:sysVer, test_version:"5.0.2195.7251")){
    security_hole(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.3521
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3521")){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.5756
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5756")){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Win32k.sys version < 5.2.3790.3291
    if(version_is_less(version:sysVer, test_version:"5.2.3790.3291")){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys version < 5.2.3790.4456
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4456")){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
