###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ezip_detect.nasl 1066 2009-03-23 14:02:24Z mar $
#
# eZip Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900524);
  script_version("Revision: 1.0 $");
  script_name(english:"eZip Version Detection");
  desc["english"] = "
  Overview: This script detects the installed version of eZip and sets
  the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets the KB for the version of eZip");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

ezipVer = registry_get_sz(key:"SOFTWARE\ediSys\eZip32", item:"Version");
if(ezipVer != NULL){
  set_kb_item(name:"eZip/Version", value:ezipVer);
}
