##############################################################################
#
#  Apple QuickTime Movie/PICT/QTVR Multiple Remote Vulnerabilities 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0185
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900121);
 script_bugtraq_id(31086);
 script_cve_id("CVE-2008-3615","CVE-2008-3635","CVE-2008-3624","CVE-2008-3625",
               "CVE-2008-3614","CVE-2008-3626","CVE-2008-3627","CVE-2008-3628",
               "CVE-2008-3629");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Apple QuickTime Movie/PICT/QTVR Multiple Remote Vulnerabilities");
 script_summary(english:"Check for vulnerable version of Apple QuickTime");
 desc["english"] = "
 Overview : This host has Apple QuickTime installed, which prone to multiple
 vulnerabilities.

 Vulnerability Insight :

        The flaws exists due to,
        - an uninitialized memory access inn the Indeo v5 codec and lack of
          proper bounds checking within QuickTimeInternetExtras.qtx file.
        - improper handling of panorama atoms in QTVR movie files.
        - improper handling of maxTilt, minFieldOfView and maxFieldOfView
          parameters in panorama track PDAT atoms.
        - an uninitialized memory access in the third-party Indeo v5 codec.
        - an invalid pointer in handling of PICT images.
        - memory corruption in handling of STSZ atoms in movie files within
          CallComponentFunctionWithStorage() function.
        - multiple memory corruption in H.264 encoded movie files.
        - parsing of movie video files in QuickTimeH264.scalar and MP4 video
          files in QuickTimeH264.qtx.

        Impact : Successful exploitation could allow remote attackers to gain
        unauthorized access to execute arbitrary code and trigger a denial of
        service condition.

 Impact Level : Application

 Affected Software/OS :
        Apple QuickTime versions prior to 7.5.5 on Windows (all)
 
 Fix : Upgrade to version 7.5.5
 http://www.apple.com/quicktime/download/

 References : http://support.apple.com/kb/HT3027
 http://www.securityfocus.com/archive/1/496161
 http://www.securityfocus.com/archive/1/496163
 http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=744

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.1
 Risk factor : High"; 

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl",
                     "secpod_apple_quicktime_detection_win_900124.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(egrep(pattern:"^([0-6]\..*|7\.([0-4](\..*)?|5(\.[0-4])?))$",
          string:get_kb_item("QuickTime/Win/Ver"))){
        security_hole(0);
 }

