#
# This script was written by Michel Arboi <arboi@alussinan.org>
# This script was modified by Michael Meyer
# GPL
#
# Note: this script is not very useful because mldonkey only allows
# connections from localhost by default

 desc["english"] = "
 MLDonkey web interface might be running on this port. This peer to peer 
 software is used to share files.

 1. This may be illegal.
 2. You may have access to confidential files
 3. It may eat too much bandwidth

 Solution: disable it

 Risk factor : Medium";

if(description)
{
  script_id(11125);
  script_version ("$Revision: 2818 $");
 
  script_name(english:"MLDonkey web interface detection");
  script_description(english:desc["english"]);
 
  summary["english"] = "Detect mldonkey web interface";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
  family["english"] = "Peer-To-Peer File Sharing";
  script_family(english:family["english"]);
  script_dependencie("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 4080);

  exit(0);
}

include("http_func.inc");
include("misc_func.inc");
include("http_keepalive.inc");

ports = add_port_in_list(list:get_kb_list("Services/www"), port:4080);

foreach port (ports)
{
 banner = get_http_banner(port: port);
 
 if( banner == NULL )continue;

 if( egrep(pattern: "MLDonkey", string: banner, icase:1) ) { 
  if( ! egrep(pattern:"failure", string: banner, icase:1 )) { 
     vers = string("unknown");
     if( ereg(pattern: "^HTTP/1\.[01] +403", string: banner) ) { 
       version = eregmatch(string: banner, pattern: "MLDonkey/([0-9]+\.*[0-9]*\.*[0-9]*)+");   
       if(!isnull(version[1]))vers=version[1]; 
     }     
     else if ( ereg(pattern: "^HTTP/1\.[01] +200", string: banner) ) { 
       req = http_get(item:string("/oneframe.html"), port:port);
       buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
       version = eregmatch(string: buf, pattern: "Welcome to MLDonkey ([0-9]+\.*[0-9]*\.*[0-9]*).*");
       if(!isnull(version[1]))vers=version[1];
       if(!islocalhost())ml_www_remote = TRUE;
     }  
  
   info = string("Medium\n\nMLDonkey Version (");
   info += vers;
   info += string(") was detected on the remote host.\n");
   if(ml_www_remote) {
     info += string("\nRemote access to MLDonkey web interface from ");
     info +=  this_host_name();
     info +=  string(" is allowed!\n");
   }

   desc = ereg_replace(
        string:desc["english"],
        pattern:"Medium$",
        replace:info
    );

   set_kb_item(name: string("www/", port, "/MLDonkey/version"), value: string(vers));
   set_kb_item(name: string("MLDonkey/www/port/"), value: port);

   if(ml_www_remote) {
     set_kb_item(name: string("www/", port, "/MLDonkey/remote/"), value: 1);
   }

   security_note(port:port,data:desc);
   exit(0);
  } 
 }   
}

exit(0);
