###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libcairo regression USN-550-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840008);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "550-2");
  script_cve_id("");
  script_name(english: "Ubuntu Update for libcairo regression USN-550-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-550-1 fixed vulnerabilities in Cairo.  The upstream fixes were incomplete,
  and under certain situations, applications using Cairo would crash with a
  floating point error.  This update fixes the problem.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  Peter Valchev discovered that Cairo did not correctly decode PNG image data.
  By tricking a user or automated system into processing a specially crafted
  PNG with Cairo, a remote attacker could execute arbitrary code with user
  privileges.

  Affected Software/OS:
  libcairo regression on Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-December/000640.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libcairo regression");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libcairo-directfb2-dev", ver:"1.4.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo-directfb2", ver:"1.4.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo2-dev", ver:"1.4.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo2", ver:"1.4.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo2-doc", ver:"1.4.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libcairo-directfb2-dev", ver:"1.4.10-1ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo-directfb2", ver:"1.4.10-1ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo2-dev", ver:"1.4.10-1ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo2", ver:"1.4.10-1ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcairo2-doc", ver:"1.4.10-1ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}