###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for apache2 vulnerabilities USN-499-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840092);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "499-1");
  script_cve_id("CVE-2006-5752", "CVE-2007-1863", "CVE-2007-3304");
  script_name(english: "Ubuntu Update for apache2 vulnerabilities USN-499-1");
  desc["english"] = "

  Vulnerability Insight:

  Stefan Esser discovered that mod_status did not force a character set,
  which could result in browsers becoming vulnerable to XSS attacks when
  processing the output.  If a user were tricked into viewing server
  status output during a crafted server request, a remote attacker could
  exploit this to modify the contents, or steal confidential data (such as
  passwords), within the same domain.  By default, mod_status is disabled
  in Ubuntu. (CVE-2006-5752)
  
  Niklas Edmundsson discovered that the mod_cache module could be made to
  crash using a specially crafted request.  A remote user could use this
  to cause a denial of service if Apache was configured to use a threaded
  worker.  By default, mod_cache is disabled in Ubuntu. (CVE-2007-1863)
  
  A flaw was discovered in the signal handling of Apache.  A local
  attacker could trick Apache into sending SIGUSR1 to other processes.
  The vulnerable code was only present in Ubuntu Feisty. (CVE-2007-3304)

  Affected Software/OS:
  apache2 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-August/000574.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of apache2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.3-3.2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}