###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for moin vulnerabilities USN-458-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840079);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "458-1");
  script_cve_id("CVE-2007-2423");
  script_name(english: "Ubuntu Update for moin vulnerabilities USN-458-1");
  desc["english"] = "

  Vulnerability Insight:

  A flaw was discovered in MoinMoin's error reporting when using the
  AttachFile action.  By tricking a user into viewing a crafted MoinMoin
  URL, an attacker could execute arbitrary JavaScript as the current
  MoinMoin user, possibly exposing the user's authentication information
  for the domain where MoinMoin was hosted. (CVE-2007-2423)
  
  Flaws were discovered in MoinMoin's ACL handling for calendars and
  includes.  Unauthorized users would be able to read pages that would
  otherwise be unavailable to them.

  Affected Software/OS:
  moin vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-May/000527.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of moin vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.3-1.1ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.3-1.1ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.2-1ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.2-1ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-moinmoin", ver:"1.5.2-1ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.3-1ubuntu1.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.3-1ubuntu1.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-moinmoin", ver:"1.5.3-1ubuntu1.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}