###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gnupg2, gpgme1.0 vulnerability USN-432-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840054);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "432-2");
  script_cve_id("CVE-2007-1263");
  script_name(english: "Ubuntu Update for gnupg2, gpgme1.0 vulnerability USN-432-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-432-1 fixed a vulnerability in GnuPG.  This update provides the
  corresponding updates for GnuPG2 and the GPGME library.
  
  Original advisory details:
  
  Gerardo Richarte from Core Security Technologies discovered that when
  gnupg is used without --status-fd, there is no way to distinguish
  initial unsigned messages from a following signed message.  An attacker
  could inject an unsigned message, which could fool the user into
  thinking the message was entirely signed by the original sender.

  Affected Software/OS:
  gnupg2, gpgme1.0 vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000503.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnupg2, gpgme1.0 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libgpgme11-dev", ver:"1.1.0-1ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgpgme11", ver:"1.1.0-1ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"gnupg-agent", ver:"1.9.21-0ubuntu5.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gnupg2", ver:"1.9.21-0ubuntu5.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gpgsm", ver:"1.9.21-0ubuntu5.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgpgme11-dev", ver:"1.1.2-2ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgpgme11", ver:"1.1.2-2ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}