###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for avahi vulnerability USN-402-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840023);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "402-1");
  script_cve_id("CVE-2006-6870");
  script_name(english: "Ubuntu Update for avahi vulnerability USN-402-1");
  desc["english"] = "

  Vulnerability Insight:

  A flaw was discovered in Avahi's handling of compressed DNS packets.  If
  a specially crafted reply were received over the network, the Avahi
  daemon would go into an infinite loop, causing a denial of service.

  Affected Software/OS:
  avahi vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000461.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of avahi vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core4", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-cil", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"monodoc-avahi-manual", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-avahi", ver:"0.6.10-0ubuntu3.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core4", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-1", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-dev", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-avahi", ver:"0.6.13-2ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client1", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common0", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core1", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib0", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-0", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-0", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-dev", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-cil", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-avahi", ver:"0.5.2-1ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}