###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seamonkey_mult_vuln_dec08_lin.nasl 725 2008-12-19 18:12:56Z dec $
#
# Mozilla Seamonkey Multiple Vulnerabilities December-08 (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800093);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5500", "CVE-2008-5501", "CVE-2008-5502", "CVE-2008-5503",
                "CVE-2008-5506", "CVE-2008-5507", "CVE-2008-5508", "CVE-2008-5510",
                "CVE-2008-5511", "CVE-2008-5512");
  script_bugtraq_id(32882);
  script_name(english:"Mozilla Seamonkey Multiple Vulnerabilities December-08 (Linux)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Seamonkey and is prone
  to multiple vulnerabilities.

  Vulnerability:
  Refer to the reference links for more information on the vulnerabilities.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  bypass security restrictions, sensitive information disclosure, cross
  site scripting attacks and execute JavaScript code with chrome privileges.

  Impact Level: System

  Affected Software/OS:
  Seamonkey version prior to 1.1.14 on Linux.

  Fix: Upgrade to Seamonkey version 1.1.14 or later
  http://www.seamonkey-project.org/releases/

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-60.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-61.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-64.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-65.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-66.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-67.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-68.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("gb_seamonkey_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

smVer = get_kb_item("Seamonkey/Linux/Ver");
if(!smVer){
  exit(0);
}

# Seamonkey version < 1.1.14
if(version_is_less(version:smVer, test_version:"1.1.14")){
  security_hole(0);
}
