###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_senddoc_tmp_file_creation_vuln_win.nasl 0438 2008-11-05 12:33:52Z nov $
#
# OpenOffice senddoc Insecure Temporary File Creation Vulnerability (Win)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800128);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-4937");
  script_bugtraq_id(30925);
  script_name(english:"OpenOffice senddoc Insecure Temporary File Creation Vulnerability (Win)");
  desc["english"] = "

  Overview: The host has OpenOffice installed and is prone to Insecure
  Temporary File Creation Vulnerability.

  Vulnerability Insight:
  The flaw exists due to OpenOffice 'senddoc' which creates temporary files in an
  insecure manner, that allows users to overwrite files via a symlink attack
  on a /tmp/log.obr.##### temporary file.

  Impact: Successful exploitation allows attackers to delete or corrupt
  sensitive files, which may result in a denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  OpenOffice.org 2.4.1 on Windows (Any).

  Fix: Upgrade OpenOffice higher version.
  http://download.openoffice.org/index.html

  References:
  http://www.openwall.com/lists/oss-security/2008/10/30/2

  CVSS Score:
    CVSS Base Score     : 7.6 (AV:N/AC:H/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key);

foreach item (keys)
{
  if("OpenOffice.org" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    openOffVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(openOffVer == "2.4.9310"){
        security_hole(0);
    }
    exit(0);
  }
}
