###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_norton_internet_sec_dos_vuln.nasl 665 2008-12-15 14:41:50Z dec $
#
# Norton Internet Security Denial of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800321);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5427");
  script_name(english:"Norton Internet Security Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host has Norton AntiVius in Norton Internet Security installed
  and is prone to Denial of Service Vulnerability.

  Vulnerability Insight:
  The flaws are caused due to improper handling of multipart/mixed e-mail messages
  with many MIME parts and stack consumption by Content-type: message/rfc822
  headers via a large e-mail message.

  Impact:
  Successful exploitation will allow remote attackers to deny the service.

  Impact Level: Application

  Affected Software/OS:
  Symantec, Norton AntiVirus version 15.5.0.23 on Windows.

  Fix: No solution or patch is available as on 15th December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.symantec.com/norton/index.jsp

  References:
  http://mime.recurity.com/cgi-bin/twiki/view/Main/AttackIntro
  http://www.securityfocus.com/archive/1/archive/1/499038/100/0/threaded
  http://www.securityfocus.com/archive/1/archive/1/499045/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Norton AntiVirus");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for Norton Internet Security install
if(!registry_key_exists(key:"SOFTWARE\Symantec\Internet Security")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("Norton AntiVirus" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    navVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(!navVer){
      exit(0);
    }

    # Grep of version Norton AntiVirus 15.5.0.23
    if(navVer =~ "15.5.0.23"){
      security_warning(0);
    }
    exit(0);
  }
}
