###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for clamav MDVSA-2008:088 (clamav)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830609);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:088");
  script_cve_id("CVE-2007-6595", "CVE-2008-0314", "CVE-2008-0318", "CVE-2008-0728", "CVE-2008-1100", "CVE-2008-1387", "CVE-2008-1833", "CVE-2008-1835", "CVE-2008-1836", "CVE-2008-1837");
  script_name(english: "Mandriva Update for clamav MDVSA-2008:088 (clamav)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple vulnerabilities were discovered in ClamAV and corrected with
  the 0.93 release, including:
  
  ClamAV 0.92 allowed local users to overwrite arbitrary files via
  a symlink attack on temporary files or on .ascii files in sigtool,
  when utf16-decode is enabled (CVE-2007-6595).
  
  A heap-based buffer overflow in ClamAV 0.92.1 allowed remote attackers
  to execute arbitrary code via a crafted PeSpin packed PE binary
  (CVE-2008-0314).
  
  An integer overflow in libclamav prior to 0.92.1 allowed remote
  attackers to cause a denial of service and possibly execute arbitrary
  code via a crafted Petite packed PE file, which triggered a heap-based
  buffer overflow (CVE-2008-0318).
  
  An unspecified vulnerability in ClamAV prior to 0.92.1 triggered heap
  corruption (CVE-2008-0728).
  
  A buffer overflow in ClamAV 0.92 and 0.92.1 allowed remote attackers
  to execute arbitrary code via a crafted Upack PE file (CVE-2008-1100).
  
  ClamAV prior to 0.93 allowed remote attackers to cause a denial of
  service (CPU consumption) via a crafted ARJ archive (CVE-2008-1387).
  
  A heap-based buffer overflow in ClamAV 0.92.1 allowed remote attackers
  to execute arbitrary code via a crafted WWPack compressed PE binary
  (CVE-2008-1833).
  
  ClamAV prior to 0.93 allowed remote attackers to bypass the scanning
  engine via a RAR file with an invalid version number (CVE-2008-1835).
  
  A vulnerability in rfc2231 handling in ClamAV prior to 0.93 allowed
  remote attackers to cause a denial of service (crash) via a crafted
  message that produced a string that was not null terminated, triggering
  a buffer over-read (CVE-2008-1836).
  
  A vulnerability in libclamunrar in ClamAV prior to 0.93 allowed remote
  attackers to cause a denial of service (crash) via a crafted RAR file
  (CVE-2008-1837).
  
  Other bugs have also been corrected in 0.93 which is being provided
  with this update.  Because this new version has increased the major
  of the libclamav library, updated dependent packages are also being
  provided.

  Affected Software/OS:
  clamav on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-04/msg00011.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of clamav");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-milter", rpm:"clamav-milter~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamd", rpm:"clamd~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamdmon", rpm:"clamdmon~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav4", rpm:"libclamav4~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav-devel", rpm:"libclamav-devel~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav4", rpm:"lib64clamav4~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav-devel", rpm:"lib64clamav-devel~0.93~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-milter", rpm:"clamav-milter~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamd", rpm:"clamd~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamdmon", rpm:"clamdmon~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.42~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav4", rpm:"libclamav4~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav-devel", rpm:"libclamav-devel~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav4", rpm:"lib64clamav4~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav-devel", rpm:"lib64clamav-devel~0.93~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-milter", rpm:"clamav-milter~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamd", rpm:"clamd~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamdmon", rpm:"clamdmon~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dansguardian", rpm:"dansguardian~2.9.9.2~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.42~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav4", rpm:"libclamav4~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav-devel", rpm:"libclamav-devel~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav4", rpm:"lib64clamav4~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav-devel", rpm:"lib64clamav-devel~0.93~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}