###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mplayer MDVSA-2008:045 (mplayer)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830756);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:045");
  script_cve_id("CVE-2008-0225", "CVE-2008-0238", "CVE-2008-0485", "CVE-2008-0486", "CVE-2008-0629", "CVE-2008-0630");
  script_name(english: "Mandriva Update for mplayer MDVSA-2008:045 (mplayer)");
  desc["english"] = "

  Vulnerability Insight:

  Heap-based buffer overflow in the rmff_dump_cont function in
  input/libreal/rmff.c in xine-lib 1.1.9 and earlier allows remote
  attackers to execute arbitrary code via the SDP Abstract attribute,
  related to the rmff_dump_header function and related to disregarding
  the max field. Although originally a xine-lib issue, also affects
  MPlayer due to code similarity. (CVE-2008-0225)
  
  Multiple heap-based buffer overflows in the rmff_dump_cont function
  in input/libreal/rmff.c in xine-lib 1.1.9 allow remote attackers
  to execute arbitrary code via the SDP (1) Title, (2) Author, or
  (3) Copyright attribute, related to the rmff_dump_header function,
  different vectors than CVE-2008-0225. Although originally a xine-lib
  issue, also affects MPlayer due to code similarity. (CVE-2008-0238)
  
  Array index error in libmpdemux/demux_mov.c in MPlayer 1.0 rc2 and
  earlier might allow remote attackers to execute arbitrary code via
  a QuickTime MOV file with a crafted stsc atom tag. (CVE-2008-0485)
  
  Array index vulnerability in libmpdemux/demux_audio.c in MPlayer
  1.0rc2 and SVN before r25917, and possibly earlier versions, as
  used in Xine-lib 1.1.10, might allow remote attackers to execute
  arbitrary code via a crafted FLAC tag, which triggers a buffer
  overflow. (CVE-2008-0486)
  
  Buffer overflow in stream_cddb.c in MPlayer 1.0rc2 and SVN
  before r25824 allows remote user-assisted attackers to execute
  arbitrary code via a CDDB database entry containing a long album
  title. (CVE-2008-0629)
  
  Buffer overflow in url.c in MPlayer 1.0rc2 and SVN before r25823 allows
  remote attackers to execute arbitrary code via a crafted URL that
  prevents the IPv6 parsing code from setting a pointer to NULL, which
  causes the buffer to be reused by the unescape code. (CVE-2008-0630)
  
  The updated packages have been patched to prevent these issues.

  Affected Software/OS:
  mplayer on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00022.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mplayer");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libdha1.0", rpm:"libdha1.0~1.0~1.rc1.11.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mencoder", rpm:"mencoder~1.0~1.rc1.11.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer", rpm:"mplayer~1.0~1.rc1.11.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-doc", rpm:"mplayer-doc~1.0~1.rc1.11.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-gui", rpm:"mplayer-gui~1.0~1.rc1.11.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libdha1.0", rpm:"libdha1.0~1.0~1.rc1.20.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mencoder", rpm:"mencoder~1.0~1.rc1.20.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer", rpm:"mplayer~1.0~1.rc1.20.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-doc", rpm:"mplayer-doc~1.0~1.rc1.20.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-gui", rpm:"mplayer-gui~1.0~1.rc1.20.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}