###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for draksnapshot MDVA-2008:135-1 (draksnapshot)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830729);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:135-1");
  script_cve_id("");
  script_name(english: "Mandriva Update for draksnapshot MDVA-2008:135-1 (draksnapshot)");
  desc["english"] = "

  Vulnerability Insight:

  This update fixes several issues in draksnapshot:
  
  The draksnapshot applet received the following fixes:
  
  - on desktop startup, it will wait for 30s before checking for
  available disc so that notification is positioned at the right place,
  on the applet icon
  - it prevents crashing if DBus is not reachable, and reports DBus
  errors
  - it prevents crashing if DBus is active, but HAL is not (#44434)
  - if all discs are unmounted, the applet will hide (#41176)
  - it prevents running more than once
  - it uses HAL in order to detect discs available for backup, thus
  fixing detecting some internal SATA discs as discs available for backup
  (#41107)
  
  It also uses new icons from Mandriva Linux 2009.0.
  
  The draksnapshot configuration tool also received the following fixes:
  
  - it stops saving config when clicking Close (#39790); one has to
  click on Apply in order to save the config
  - on first run, it offers backup in mounted disc path, instead of
  defaulting to some place in the root filesystem which could previously
  be filled up (#39802)
  - it no longer offers to configure some obscure advanced options
  - it now allows for disabling backups
  - it generates anacron-friendly cron files
  
  Update:
  
  An updated draksnapshot is now available for Mandriva Linux 2009.0.

  Affected Software/OS:
  draksnapshot on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00011.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of draksnapshot");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"draksnapshot", rpm:"draksnapshot~0.19~2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}