###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for laptop-mode-tools MDVA-2008:047 (laptop-mode-tools)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830769);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:047");
  script_cve_id("");
  script_name(english: "Mandriva Update for laptop-mode-tools MDVA-2008:047 (laptop-mode-tools)");
  desc["english"] = "

  Vulnerability Insight:

  Default power management settings for hard disks may trigger
  excessive load/unload cycles on some disk models, and shorten their
  lifetime. This update package fixes the problem, by setting a less
  aggressive hard disk power management level.

  Affected Software/OS:
  laptop-mode-tools on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-04/msg00016.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of laptop-mode-tools");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"laptop-mode-tools", rpm:"laptop-mode-tools~1.32~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}