###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for apache-mod_perl MDKSA-2007:083 (apache-mod_perl)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830109);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:083");
  script_cve_id("CVE-2007-1349");
  script_name(english: "Mandriva Update for apache-mod_perl MDKSA-2007:083 (apache-mod_perl)");
  desc["english"] = "

  Vulnerability Insight:

  PerlRun.pm in Apache mod_perl 1.30 and earlier, and RegistryCooker.pm
  in mod_perl 2.x, does not properly escape PATH_INFO before use in a
  regular expression, which allows remote attackers to cause a denial
  of service (resource consumption) via a crafted URI.
  
  Updated packages have been patched to correct this issue.

  Affected Software/OS:
  apache-mod_perl on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00018.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of apache-mod_perl");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~2.0.3~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_perl-devel", rpm:"apache-mod_perl-devel~2.0.3~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~2.0.2~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_perl-devel", rpm:"apache-mod_perl-devel~2.0.2~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~2.0.54_2.0.1~6.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_perl-devel", rpm:"apache-mod_perl-devel~2.0.54_2.0.1~6.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}