###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDKSA-2007:040 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830178);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:040");
  script_cve_id("CVE-2006-5749", "CVE-2006-5753", "CVE-2006-6053", "CVE-2006-4814");
  script_name(english: "Mandriva Update for kernel MDKSA-2007:040 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  Some vulnerabilities were discovered and corrected in the Linux 2.6
  kernel:
  
  The isdn_ppp_ccp_reset_alloc_state function in drivers/isdn/isdn_ppp.c
  in the Linux 2.4 kernel before 2.4.34-rc4, as well as the 2.6 kernel,
  does not call the init_timer function for the ISDN PPP CCP reset state
  timer, which has unknown attack vectors and results in a system crash.
  (CVE-2006-5749)
  
  The listxattr syscall can corrupt user space under certain
  circumstances. The problem seems to be related to signed/unsigned
  conversion during size promotion. (CVE-2006-5753)
  
  The ext3fs_dirhash function in Linux kernel 2.6.x allows local users to
  cause a denial of service (crash) via an ext3 stream with malformed
  data structures. (CVE-2006-6053)
  
  The mincore function in the Linux kernel before 2.4.33.6, as well as
  the 2.6 kernel, does not properly lock access to user space, which has
  unspecified impact and attack vectors, possibly related to a deadlock.
  (CVE-2006-4814)
  
  The provided packages are patched to fix these vulnerabilities.  All
  users are encouraged to upgrade to these updated kernels immediately
  and reboot to effect the fixes.
  
  In addition to these security fixes, other fixes have been included
  such as:
  
  - Add Ralink RT2571W/RT2671 WLAN USB support (rt73 module) - Fix
  sys_msync() to report -ENOMEM as before when an unmapped area falls
  within its range, and not to overshoot (LSB regression) - Avoid disk
  sector_t overflow for &gt;2TB ext3 filesystem - USB: workaround to fix HP
  scanners detection (#26728) - USB: unusual_devs.h for Sony floppy
  (#28378) - Add preliminary ICH9 support - Add TI sd card reader
  support - Add RT61 driver - KVM update - Fix bttv vbi offset
  
  To update your kernel, please follow the directions located at:
  
  http://www.mandriva.com/en/security/kernelupdate

  Affected Software/OS:
  kernel on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00009.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise", rpm:"kernel-enterprise~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy", rpm:"kernel-legacy~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.17.10mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}