###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdelibs MDKSA-2007:031 (kdelibs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830077);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:031");
  script_cve_id("CVE-2007-0478", "CVE-2007-0537");
  script_name(english: "Mandriva Update for kdelibs MDKSA-2007:031 (kdelibs)");
  desc["english"] = "

  Vulnerability Insight:

  FIXME Konqueror 3.5.5 does not properly parse HTML comments in title
  tags, which allows remote attackers to conduct cross-site scripting
  (XSS) attacks and bypass some XSS protection schemes by embedding
  certain HTML tags within a comment, a related issue to CVE-2007-0478.
  
  Updated packages have been patched to correct this issue.

  Affected Software/OS:
  kdelibs on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00000.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kdelibs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kdelibs-common", rpm:"kdelibs-common~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs-devel-doc", rpm:"kdelibs-devel-doc~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore4", rpm:"libkdecore4~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore4-devel", rpm:"libkdecore4-devel~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs", rpm:"kdelibs~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore4", rpm:"lib64kdecore4~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore4-devel", rpm:"lib64kdecore4-devel~3.5.4~19.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}