###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clamav_detect_win.nasl 1466 2009-04-15 16:42:37Z apr $
#
# ClamAV Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800555);
  script_version("$Revision: 1.1 $");
  script_name(english:"ClamAV Version Detection (Win)");
  desc["english"] = "
  Overview : This script retrieves ClamAV Version for Windows and saves the
  result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_family(english:"Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_summary(english:"Set Version of ClamAV in KB for Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\ClamWin")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  clamName = registry_get_sz(key:key + item, item:"DisplayName");
  if("ClamWin" >< clamName)
  {
    clamVer = eregmatch(pattern:"ClamWin Free Antivirus ([0-9.]+)", string:clamName);
    if(clamVer[1] != NULL){
       set_kb_item(name:"ClamAV/Win/Ver", value:clamVer[1]);
    }
    exit(0);
  }
}
