###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for dnsmasq RHSA-2008:0789-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870106);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0789-01");
  script_cve_id("CVE-2008-1447");
  script_name(english: "RedHat Update for dnsmasq RHSA-2008:0789-01");
  desc["english"] = "

  Vulnerability Insight:
  Dnsmasq is lightweight DNS forwarder and DHCP server. It is designed to
  provide DNS and, optionally, DHCP, to a small network.
  
  The dnsmasq DNS resolver used a fixed source UDP port. This could have made
  DNS spoofing attacks easier. dnsmasq has been updated to use random UDP
  source ports, helping to make DNS spoofing attacks harder. (CVE-2008-1447)
  
  All dnsmasq users are advised to upgrade to this updated package, that
  upgrades dnsmasq to version 2.45, which resolves this issue.


  Affected Software/OS:
  dnsmasq on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00005.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dnsmasq");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"dnsmasq", rpm:"dnsmasq~2.45~1.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dnsmasq-debuginfo", rpm:"dnsmasq-debuginfo~2.45~1.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}