###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0237-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870130);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0237-01");
  script_cve_id("CVE-2005-0504", "CVE-2007-6282", "CVE-2008-0007", "CVE-2008-1375", "CVE-2008-1615", "CVE-2008-1669");
  script_name(english: "RedHat Update for kernel RHSA-2008:0237-01");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  These updated packages fix the following security issues:
  
  * the absence of a protection mechanism when attempting to access a
  critical section of code has been found in the Linux kernel open file
  descriptors control mechanism, fcntl. This could allow a local unprivileged
  user to simultaneously execute code, which would otherwise be protected
  against parallel execution. As well, a race condition when handling locks
  in the Linux kernel fcntl functionality, may have allowed a process
  belonging to a local unprivileged user to gain re-ordered access to the
  descriptor table. (CVE-2008-1669, Important)
  
  * on AMD64 architectures, the possibility of a kernel crash was discovered
  by testing the Linux kernel process-trace ability. This could allow a local
  unprivileged user to cause a denial of service (kernel crash).
  (CVE-2008-1615, Important)
  
  * the absence of a protection mechanism when attempting to access a
  critical section of code, as well as a race condition, have been found
  in the Linux kernel file system event notifier, dnotify. This could allow a
  local unprivileged user to get inconsistent data, or to send arbitrary
  signals to arbitrary system processes. (CVE-2008-1375, Important)
  
  Red Hat would like to thank Nick Piggin for responsibly disclosing the
  following issue:
  
  * when accessing kernel memory locations, certain Linux kernel drivers
  registering a fault handler did not perform required range checks. A local
  unprivileged user could use this flaw to gain read or write access to
  arbitrary kernel memory, or possibly cause a kernel crash.
  (CVE-2008-0007, Important)
  
  * the possibility of a kernel crash was found in the Linux kernel IPsec
  protocol implementation, due to improper handling of fragmented ESP
  packets. When an attacker controlling an intermediate router fragmented
  these packets into very small pieces, it would cause a kernel crash on the
  receiving node during packet reassembly. (CVE-2007-6282, Important)
  
  * a flaw in the MOXA serial driver could allow a local unprivileged user
  to perform privileged operations, such as replacing firmware.
  (CVE-2005-0504, Important)
  
  As well, these updated packages fix the following bugs:
  
  * multiple buffer overflows in the neofb driver have been resolved. It was
  not possible for an unprivileged user to exploit these issues, and as such,
  they have not been handled as ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00002.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem-devel", rpm:"kernel-hugemem-devel~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-largesmp", rpm:"kernel-largesmp~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-largesmp-devel", rpm:"kernel-largesmp-devel~2.6.9~67.0.15.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}