###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for apache RHSA-2008:0004-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870175);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0004-01");
  script_cve_id("CVE-2007-4465", "CVE-2007-5000", "CVE-2007-6388", "CVE-2008-0005");
  script_name(english: "RedHat Update for apache RHSA-2008:0004-01");
  desc["english"] = "

  Vulnerability Insight:
  The Apache HTTP Server is a popular Web server.
  
  A flaw was found in the mod_imap module. On sites where mod_imap was
  enabled and an imagemap file was publicly available, a cross-site scripting
  attack was possible. (CVE-2007-5000)
  
  A flaw was found in the mod_autoindex module. On sites where directory
  listings are used, and the &quot;AddDefaultCharset&quot; directive has been removed
  from the configuration, a cross-site scripting attack was possible against
  Web browsers which did not correctly derive the response character set
  following the rules in RFC 2616. (CVE-2007-4465)
  
  A flaw was found in the mod_status module. On sites where mod_status was
  enabled and the status pages were publicly available, a cross-site
  scripting attack was possible. (CVE-2007-6388)
  
  A flaw was found in the mod_proxy_ftp module. On sites where mod_proxy_ftp
  was enabled and a forward proxy was configured, a cross-site scripting
  attack was possible against Web browsers which did not correctly derive the
  response character set following the rules in RFC 2616. (CVE-2008-0005)
  
  Users of Apache should upgrade to these updated packages, which contain
  backported patches to resolve these issues. Users should restart Apache
  after installing this update.


  Affected Software/OS:
  apache on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00005.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of apache");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"apache", rpm:"apache~1.3.27~14.ent", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~1.3.27~14.ent", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-manual", rpm:"apache-manual~1.3.27~14.ent", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}