###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for tog-pegasus RHSA-2008:0002-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870162);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0002-01");
  script_cve_id("CVE-2008-0003");
  script_name(english: "RedHat Update for tog-pegasus RHSA-2008:0002-01");
  desc["english"] = "

  Vulnerability Insight:
  The tog-pegasus packages provide OpenPegasus Web-Based Enterprise
  Management (WBEM) services. WBEM is a platform and resource independent
  DMTF standard that defines a common information model, and communication
  protocol for monitoring and controlling resources.
  
  During a security audit, a stack buffer overflow flaw was found in the PAM
  authentication code in the OpenPegasus CIM management server. An
  unauthenticated remote user could trigger this flaw and potentially execute
  arbitrary code with root privileges. (CVE-2008-0003)
  
  Note that the tog-pegasus packages are not installed by default on Red Hat
  Enterprise Linux. The Red Hat Security Response Team believes that it would
  be hard to remotely exploit this issue to execute arbitrary code, due to
  the default SELinux targeted policy on Red Hat Enterprise Linux 4 and 5,
  and the SELinux memory protection tests enabled by default on Red Hat
  Enterprise Linux 5.
  
  Users of tog-pegasus should upgrade to these updated packages, which
  contain a backported patch to resolve this issue. After installing the
  updated packages the tog-pegasus service should be restarted.


  Affected Software/OS:
  tog-pegasus on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00000.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tog-pegasus");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"tog-pegasus", rpm:"tog-pegasus~2.6.1~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-debuginfo", rpm:"tog-pegasus-debuginfo~2.6.1~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-devel", rpm:"tog-pegasus-devel~2.6.1~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"tog-pegasus", rpm:"tog-pegasus~2.5.1~5.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-debuginfo", rpm:"tog-pegasus-debuginfo~2.5.1~5.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-devel", rpm:"tog-pegasus-devel~2.5.1~5.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-test", rpm:"tog-pegasus-test~2.5.1~5.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}