###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for autofs RHSA-2007:1176-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870192);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:1176-01");
  script_cve_id("CVE-2007-6285", "CVE-2007-5964");
  script_name(english: "RedHat Update for autofs RHSA-2007:1176-01");
  desc["english"] = "

  Vulnerability Insight:
  The autofs utility controls the operation of the automount daemon, which
  automatically mounts file systems when you use them, and unmounts them when
  you are not using them. This can include network file systems and CD-ROMs.
  
  There was a security issue with the default configuration of autofs version
  5, whereby the entry for the &quot;-hosts&quot; map did not specify the &quot;nodev&quot; mount
  option. A local user with control of a remote NFS server could create
  special device files on the remote file system, that if mounted using the
  default &quot;-hosts&quot; map, could allow the user to access important system
  devices. (CVE-2007-6285)
  
  This issue is similar to CVE-2007-5964, which fixed a missing &quot;nosuid&quot;
  mount option in autofs. Both the &quot;nodev&quot; and &quot;nosuid&quot; options should be
  enabled to prevent a possible compromise of machine integrity.
  
  Due to the fact that autofs always mounted &quot;-hosts&quot; map entries &quot;dev&quot; by
  default, autofs has now been altered to always use the &quot;nodev&quot; option when
  mounting from the default &quot;-hosts&quot; map. The &quot;dev&quot; option must be explicitly
  given in the master map entry to revert to the old behavior. This change
  affects only the &quot;-hosts&quot; map which corresponds to the &quot;/net&quot; entry in the
  default configuration.
  
  All autofs users are advised to upgrade to these updated packages, which
  resolve this issue.
  
  Red Hat would like to thank Tim Baum for reporting this issue.


  Affected Software/OS:
  autofs on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-December/msg00019.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of autofs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"autofs", rpm:"autofs~5.0.1~0.rc2.55.el5.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"autofs-debuginfo", rpm:"autofs-debuginfo~5.0.1~0.rc2.55.el5.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}