###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for bzip2 CESA-2008:0893-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880235);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0893-01");
  script_cve_id("CVE-2008-1372");
  script_name(english: "CentOS Update for bzip2 CESA-2008:0893-01 centos2 i386");
  desc["english"] = "

  Vulnerability Insight:
  Bzip2 is a freely available, high-quality data compressor. It provides both
  stand-alone compression and decompression utilities, as well as a shared
  library for use with other programs.
  
  A buffer over-read flaw was discovered in the bzip2 decompression routine.
  This issue could cause an application linked against the libbz2 library to
  crash when decompressing malformed archives. (CVE-2008-1372)
  
  Users of bzip2 should upgrade to these updated packages, which contain a
  backported patch to resolve this issue.


  Affected Software/OS:
  bzip2 on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-September/015254.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bzip2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS2")
{

  if(isrpmvuln(pkg:"bzip2", rpm:"bzip2~1.0.1~5.EL2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bzip2-devel", rpm:"bzip2-devel~1.0.1~5.EL2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bzip2-libs", rpm:"bzip2-libs~1.0.1~5.EL2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}