#
#VID 86a98b57-fb8e-11d8-9343-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52401);
 script_cve_id("CVE-2004-0642", "CVE-2004-0643", "CVE-2004-0772");
 script_version ("$");
 name["english"] = "FreeBSD Ports: krb5";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: krb5

CVE-2004-0642
Double-free vulnerabilities in the error handling code for ASN.1
decoders in the (1) Key Distribution Center (KDC) library and (2)
client library for MIT Kerberos 5 (krb5) 1.3.4 and earlier may allow
remote attackers to execute arbitrary code.

CVE-2004-0643
Double-free vulnerability in the krb5_rd_cred function for MIT
Kerberos 5 (krb5) 1.3.1 and earlier may allow local users to execute
arbitrary code.

CVE-2004-0772
Double-free vulnerabilities in error handling code in krb524d for MIT
Kerberos 5 (krb5) 1.2.8 and earlier may allow remote attackers to
execute arbitrary code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2004-002-dblfree.txt
http://www.vuxml.org/freebsd/86a98b57-fb8e-11d8-9343-000a95bc6fae.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: krb5";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"krb5");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.4_1")<=0) {
    security_note(0, data:"Package krb5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
