#
#VID f47f2746-12c5-11dd-bab7-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60883);
 script_cve_id("CVE-2008-0564");
 script_bugtraq_id(27630);
 script_version ("$");
 name["english"] = "FreeBSD Ports: ja-mailman, mailman, mailman-with-htdig";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ja-mailman
   mailman
   mailman-with-htdig

CVE-2008-0564
Multiple cross-site scripting (XSS) vulnerabilities in Mailman before
2.1.10b1 allow remote attackers to inject arbitrary web script or HTML
via unspecified vectors related to (1) editing templates and (2) the
list's 'info attribute' in the web administrator interface, a
different vulnerability than CVE-2006-3636.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.ubuntu.com/usn/usn-586-1
http://secunia.com/advisories/28794
http://sourceforge.net/project/shownotes.php?release_id=593924
http://www.vuxml.org/freebsd/f47f2746-12c5-11dd-bab7-0016179b2dd5.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: ja-mailman, mailman, mailman-with-htdig";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ja-mailman");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.10")<0) {
    security_note(0, data:"Package ja-mailman version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mailman");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.10")<0) {
    security_note(0, data:"Package mailman version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mailman-with-htdig");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.10")<0) {
    security_note(0, data:"Package mailman-with-htdig version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
