#
#VID 4fb43b2f-46a9-11dd-9d38-00163e000016
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(61219);
 script_cve_id("CVE-2008-1806", "CVE-2008-1807", "CVE-2008-1808");
 script_bugtraq_id(29637,29639,29640,29641);
 script_version ("$");
 name["english"] = "FreeBSD Ports: freetype2";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: freetype2

CVE-2008-1806
Integer overflow in FreeType2 before 2.3.6 allows context-dependent
attackers to execute arbitrary code via a crafted set of 16-bit length
values within the Private dictionary table in a Printer Font Binary
(PFB) file, which triggers a heap-based buffer overflow.

CVE-2008-1807
FreeType2 before 2.3.6 allow context-dependent attackers to execute
arbitrary code via an invalid 'number of axes' field in a Printer Font
Binary (PFB) file, which triggers a free of arbitrary memory
locations, leading to memory corruption.

CVE-2008-1808
Multiple off-by-one errors in FreeType2 before 2.3.6 allow
context-dependent attackers to execute arbitrary code via (1) a
crafted table in a Printer Font Binary (PFB) file or (2) a crafted SHC
instruction in a TrueType Font (TTF) file, which triggers a heap-based
buffer overflow.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/30600
http://sourceforge.net/project/shownotes.php?release_id=605780
http://www.vuxml.org/freebsd/4fb43b2f-46a9-11dd-9d38-00163e000016.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: freetype2";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"freetype2");
if(!isnull(bver) && revcomp(a:bver, b:"2.3.6")<0) {
    security_note(0, data:"Package freetype2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
