# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-4078 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63922);
 script_cve_id("CVE-2009-1313");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-4078 (xulrunner)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xulrunner
announced via advisory FEDORA-2009-4078.

Update Information:

Update to Firefox 3.0.10 fixing one security issue:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.10

Depending packages rebuilt against new Firefox are also included
in this update.  Additional bugs fixed in other packages:

- totem: Fix YouTube plugin following web site changes

ChangeLog:

* Mon Apr 27 2009 Jan Horak  - 1.9.0.10-1
- Update to 1.9.0.10
* Tue Apr 21 2009 Christopher Aillon  - 1.9.0.9-1
- Update to 1.9.0.9

References:

[ 1 ] Bug #497447 - CVE-2009-1313 Firefox crash in nsTextFrame::ClearTextRun()
https://bugzilla.redhat.com/show_bug.cgi?id=497447

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xulrunner' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-4078

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-4078 (xulrunner)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9.0.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9.0.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9.0.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9.0.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
